//$Id: CExponentParameter.cpp,v 1.7 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CExponentParameter.hpp"
#include "CBounds.hpp"
#include "CMathTools.hpp"
#include "../Exceptions/CException.hpp"

//	===========================================================================

using Exponent::MathTools::CMathTools;
using Exponent::MathTools::CBounds;
using Exponent::Exceptions::CException;
using Exponent::MathTools::CExponentParameter;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CExponentParameter, CCountedObject);

//	===========================================================================
CExponentParameter::CExponentParameter(const double min, const double max, const double value) 
				  : CParameter(min, max, value)
				  , m_logOut(0)
				  , m_logMin(0)
				  , m_logMax(0)
				  , m_logData(0)
				  , m_logDifference(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CExponentParameter);
	this->setRange(min, max);
	this->setValue(value);
}

//	===========================================================================
CExponentParameter::~CExponentParameter()
{
	EXPONENT_CLASS_DESTRUCTION(CExponentParameter);
}

//	===========================================================================
void CExponentParameter::setRange(const double min, const double max)
{
	if (min <= max && min > 0.0)
	{
		CParameter::setRange(min, max);
		m_logMin  		= log(min);
		m_logMax  		= log(max);
		m_logDifference = m_logMax - m_logMin;
	}
	else
	{
		throw CException("Tried to set exponent base to 0.0", "CExponentParameteR::setRange(const double, const double)");
	}
}

//	===========================================================================
void CExponentParameter::setValue(const double value)
{
	m_logData = (value * m_logDifference) + m_logMin;
	m_logOut  = exp(m_logData);
	m_out 	  = CMathTools::clamp(m_min, m_max, m_logOut);
}